<?php
/**
 * Template Name: Legacy
 * Description: Moore's Customz legacy and story page.
 */
get_header();
?>

<section class="section" id="legacy-page">
	<div class="container-wide">
		<div class="kicker">Legacy</div>
		<h1>Moore's Customz: 40 Years of Craft & Legacy</h1>

		<div class="panel edge pad" style="margin-top: var(--sp-20);">
			<p class="lead">
				At Moore's Customz, we believe mastery isn't taught. It's earned. My journey began at age 12, and while I was offered
				a full scholarship to art school, I chose a self taught path to keep my creative voice raw and authentic.
			</p>

			<h3>1987: The Lesson of the 1969 Harley Davidson</h3>
			<p>
				My true apprenticeship started at 14 when my father challenged me to paint a 1969 Harley Davidson. I spent months on
				that bike, learning the grit and patience required for motorcycle art. That experience defined a work ethic centered
				on the craft: I don't just paint for the finish; I paint for the process.
			</p>

			<h3>The Alabama & Tennessee Years: Professional Management</h3>
			<p>
				My career reached a pivotal milestone when my work was professionally managed by Wilson LaQuire, following his
				retirement as the Director of the Moody Gallery and Dean at the University of Alabama. Under this high level
				representation, I secured commissions for major institutions and public works, including:
			</p>
			<ul class="mc-legacy-list">
				<li>The University of Alabama</li>
				<li>The National Children's Advocacy Center</li>
				<li>Bestselling Authors and National Magazines</li>
			</ul>

			<h3>Global Reach & Fine Art Roots</h3>
			<p>
				Before transitioning fully to automotive airbrushing 15 years ago, I spent decades in the worlds of Fine Art and
				Tattooing, where precision is everything.
			</p>
			<ul class="mc-legacy-list">
				<li>Gallery Presence: Exhibited internationally in Italy and Africa, and featured in the Andy Warhol and Soho Galleries in NYC.</li>
				<li>Competition Success: Winner of the ETAXI Worldwide Art Contest (Amsterdam) and ranked in the Top 100 World Artists.</li>
				<li>Cinematic Art: Commissioned film prop artist for the movie Porcelain Presence.</li>
			</ul>

			<h3>The Moore Standard Today</h3>
			<p>
				Today, Moore's Customz specializes in Automotive, Motorcycles, Firearms, and Murals. Every project, from a hand sketched
				skull to a glass like finish, is backed by 40 years of cross industry secrets. I am now passing this standard to my son,
				who has been apprenticing under my eye since he was 12 years old.
			</p>
			<p style="margin:0;">
				We let the history and the work speak for itself. If you're looking for art that carries a lifetime of experience, welcome
				to the shop. Stay Customz.
			</p>
		</div>

		<div style="margin-top: var(--sp-40);">
			<a class="btn btn-outline" href="<?php echo esc_url(home_url('/')); ?>">Back to Home</a>
		</div>
	</div>
</section>

<?php get_footer(); ?>
